/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp.display;

import DE.siemens.ad.logo.dialog.comp.display.DisplayCellRenderer;
import DE.siemens.ad.logo.dialog.comp.display.DisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.LogoDisplay;
import DE.siemens.ad.logo.dialog.comp.display.SpecialCharacterDisplayElement;
import DE.siemens.ad.logo.util.Global;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class DefaultDisplayCellRenderer
extends JLabel
implements DisplayCellRenderer {
    private static final long serialVersionUID = 1L;
    protected Color fDefaultBackground = Global.LOGO_DISPLAY_COLOR;
    protected Font fDefaultFont;
    protected Border fNoFocusBorder = new EmptyBorder(0, 0, 0, 0);

    public DefaultDisplayCellRenderer() {
        this.fDefaultFont = this.getFont();
        this.setVerticalTextPosition(3);
    }

    public Component getDisplayCellRendererComponent(LogoDisplay display, Object displayElement, boolean isSelected, boolean hasFocus, int row, int column) {
        String text = null;
        text = displayElement == null ? "" : displayElement.toString();
        this.setText(text);
        int cellWidth = 1;
        if (displayElement instanceof DisplayElement) {
            cellWidth = ((DisplayElement)displayElement).getWidth();
        }
        float fontSize = Math.min((float)display.getCellDimension().height * 1.0f, (float)(cellWidth * display.getCellDimension().width) * 0.9f);
        if (displayElement instanceof SpecialCharacterDisplayElement) {
            fontSize -= 1.0f;
        }
        if (text.length() > 0) {
            Font newFont = new Font("Arial", 0, (int)fontSize);
            if (displayElement instanceof SpecialCharacterDisplayElement && newFont.canDisplay(text.charAt(0))) {
                this.setFont(newFont);
            } else {
                newFont = this.fDefaultFont.deriveFont(0, fontSize);
                if (newFont.canDisplay(text.charAt(0))) {
                    this.setFont(newFont);
                } else {
                    this.setFont(this.fDefaultFont);
                }
            }
        }
        if (isSelected) {
            super.setForeground(UIManager.getColor("Tree.selectionForeground"));
            super.setBackground(UIManager.getColor("Tree.selectionBackground"));
        } else {
            super.setForeground(UIManager.getColor("Tree.textForeground"));
            if (display.isNextScreen(column)) {
                super.setBackground(Global.LOGO_DISPLAY_COLOR_SCREEN_2);
            } else {
                super.setBackground(this.fDefaultBackground);
            }
        }
        this.setHorizontalAlignment(0);
        this.setOpaque(true);
        if (hasFocus) {
            this.setBorder(display.getFocusBorder());
        } else {
            this.setBorder(this.fNoFocusBorder);
        }
        return this;
    }

    public Color getDefaultBackground() {
        return this.fDefaultBackground;
    }

    public void setDefaultBackground(Color defaultBackground) {
        this.fDefaultBackground = defaultBackground;
    }
}

